import pymysql
import time

# معلومات الاتصال بقاعدة بيانات competition_system
comp_host = '127.0.0.1'
comp_user = 'root'
comp_password = ''
comp_db = 'competition_system'

# معلومات الاتصال بقاعدة بيانات metatrader5
mt5_host = '127.0.0.1'
mt5_user = 'root'
mt5_password = ''
mt5_db = 'metatrader5'

while True:
    try:
        # الاتصال بقاعدة بيانات competition_system
        comp_conn = pymysql.connect(
            host=comp_host,
            user=comp_user,
            password=comp_password,
            db=comp_db
        )
        comp_cursor = comp_conn.cursor()

        # الاتصال بقاعدة بيانات metatrader5
        mt5_conn = pymysql.connect(
            host=mt5_host,
            user=mt5_user,
            password=mt5_password,
            db=mt5_db
        )
        mt5_cursor = mt5_conn.cursor()

        # استعلام لجلب جميع الحسابات النشطة في المسابقة
        comp_cursor.execute("SELECT account_number FROM competitors WHERE status = 'in_competition'")
        active_accounts = comp_cursor.fetchall()

        for (account_number,) in active_accounts:
            # جلب الرصيد من قاعدة بيانات metatrader5
            mt5_cursor.execute("SELECT Equity FROM mt5_accounts WHERE Login = %s", (account_number,))
            balance_result = mt5_cursor.fetchone()

            if balance_result:
                balance = balance_result[0]

                # تحديث الرصيد في قاعدة بيانات competition_system
                comp_cursor.execute("UPDATE competitors SET account_balance = %s WHERE account_number = %s", (balance, account_number))
                comp_conn.commit()

        # إغلاق الاتصالات بعد كل جولة تحديث
        mt5_cursor.close()
        mt5_conn.close()
        comp_cursor.close()
        comp_conn.close()

        print("all updated now, next with 5s")

    except Exception as e:
        print(f"حدث خطأ: {e}")

    # الانتظار لمدة 60 ثانية قبل التحديث التالي
    time.sleep(5)
