from flask import Flask, request, jsonify
import MT5Manager
import traceback

app = Flask(__name__)

@app.route('/create_account', methods=['POST'])
def create_account():
    try:
        data = request.json
        app.logger.info(f"Received data: {data}")

        # استخراج البيانات
        first_name = data['first_name']
        last_name = data['last_name']
        phone = data['phone']
        balance = data['balance']
        group = data['group']
        password = data['password']

        # تهيئة مدير MT5
        manager = MT5Manager.ManagerAPI()
        if manager.Connect("212.117.171.84:443", 1015, "@rTaO3Xz", 0):
            app.logger.info("Connected to MT5 server successfully.")

            user = MT5Manager.MTUser(manager)
            user.Group = group
            user.Leverage = 100
            user.Name = f"{first_name} {last_name}"
            user.Phone = phone

            # إضافة المستخدم إلى الخادم
            if manager.UserAdd(user, password, password):
                account_number = user.Login
                app.logger.info(f"User added successfully with account number: {account_number}")

                # إيداع الرصيد
                deal_id = manager.DealerBalance(account_number, float(balance), MT5Manager.MTDeal.EnDealAction.DEAL_BALANCE, "Initial deposit")
                if deal_id:
                    app.logger.info(f"Balance deposited successfully for account {account_number}")

                    # الحصول على بيانات المستخدم بعد الإضافة
                    user = manager.UserRequest(account_number)
                    if user:
                        # تعيين الحقوق لتفعيل الحساب والسماح بتغيير كلمة المرور واستخدام الـ Expert Advisors
                        user.Rights = (
                            MT5Manager.MTUser.EnUsersRights.USER_RIGHT_ENABLED   # تفعيل الحساب

                        )

                        # تحديث حقوق المستخدم على الخادم
                        if manager.UserUpdate(user):
                            app.logger.info(f"User rights updated successfully for account {account_number}")
                            manager.Disconnect()
                            return jsonify({'status': 'success', 'account_number': account_number}), 200
                        else:
                            error = MT5Manager.LastError()
                            app.logger.error(f"Failed to update user rights: {error}")
                            manager.Disconnect()
                            return jsonify({'status': 'error', 'message': f'Failed to update user rights: {error}'}), 500
                    else:
                        error = MT5Manager.LastError()
                        app.logger.error(f"Failed to request user data: {error}")
                        manager.Disconnect()
                        return jsonify({'status': 'error', 'message': f'Failed to request user data: {error}'}), 500
                else:
                    error = MT5Manager.LastError()
                    app.logger.error(f"Failed to deposit balance: {error}")
                    manager.Disconnect()
                    return jsonify({'status': 'error', 'message': f'Failed to deposit balance: {error}'}), 500
            else:
                error = MT5Manager.LastError()
                app.logger.error(f"Failed to add user: {error}")
                manager.Disconnect()
                return jsonify({'status': 'error', 'message': f'Failed to add user: {error}'}), 500
        else:
            error = MT5Manager.LastError()
            app.logger.error(f"Failed to connect to the server: {error}")
            return jsonify({'status': 'error', 'message': f'Failed to connect to MT5 server: {error}'}), 500
    except Exception as e:
        app.logger.error(f"An error occurred: {e}")
        traceback.print_exc()
        return jsonify({'status': 'error', 'message': str(e)}), 500

if __name__ == '__main__':
    app.run(debug=True)
