<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Competition;
use App\Models\Competitor;
use Illuminate\Support\Facades\Mail;
use App\Mail\CompetitorRejected;
use Carbon\Carbon;

class CheckCompetitorBalances extends Command
{
    /**
     * The name and signature of the console command.
     *
     * php artisan check:competitor-balances
     */
    protected $signature = 'check:competitor-balances';

    /**
     * The console command description.
     */
    protected $description = 'Check competitors balances and remove them from competitions if they reach stop amount';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $this->info('Checking competitor balances...');

        // الحصول على المسابقات النشطة التي تحتوي على ستوب
        $competitions = Competition::where('is_available', true)
                            ->where('has_stop', true)
                            ->whereNotNull('stop_amount')
                            ->get();

        foreach ($competitions as $competition) {
            // الحصول على المنافسين في المسابقة الذين هم في حالة 'in_competition' ورصيدهم <= stop_amount
            $competitors = Competitor::where('competition_id', $competition->id)
                                    ->where('status', Competitor::STATUS_IN_COMPETITION)
                                    ->where('account_balance', '<=', $competition->stop_amount)
                                    ->get();

            foreach ($competitors as $competitor) {
                // تحديث حالة المنافس إلى 'rejected'
                $competitor->update([
                    'status' => Competitor::STATUS_REJECTED,
                ]);

                // إرسال بريد إلكتروني لإخراجه من المسابقة
                try {
                    Mail::to($competitor->email)->send(new CompetitorRejected($competitor));
                    $this->info("Sent rejection email to {$competitor->email}");
                } catch (\Exception $e) {
                    $this->error("Failed to send email to {$competitor->email}: {$e->getMessage()}");
                }
            }
        }

        $this->info('Competitor balance check completed.');
    }
}
