<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Competitor;

class UpdateCompetitorsBalances extends Command
{
    // اسم الأمر الذي سيتم استخدامه في سطر الأوامر
    protected $signature = 'competitors:update-balances';

    // وصف الأمر
    protected $description = 'تحديث أرصدة المتسابقين من مصدر خارجي';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        // جلب جميع المتسابقين المعتمدين
        $competitors = Competitor::where('approved', true)->get();

        foreach ($competitors as $competitor) {
            // هنا ستقوم بجلب البيانات من المصدر الخارجي (مثل API)

            // على سبيل المثال، سنفترض أنك تحصل على البيانات من API
            // وسنستخدم وظيفة وهمية للتوضيح
            $apiData = $this->getBalanceFromAPI($competitor->account_number);

            // تحديث الأرصدة في قاعدة البيانات
            $competitor->account_balance = $apiData['account_balance'];
            $competitor->current_balance = $apiData['current_balance'];
            $competitor->save();

            // يمكنك إضافة تسجيل للمخرجات
            $this->info('تم تحديث رصيد المتسابق: ' . $competitor->first_name . ' ' . $competitor->last_name);
        }
    }

    // وظيفة وهمية لمحاكاة جلب البيانات من API
    private function getBalanceFromAPI($accountNumber)
    {
        // هنا تقوم بإرسال طلب إلى API والحصول على البيانات
        // سنعيد بيانات ثابتة للتوضيح

        return [
            'account_balance' => rand(1000, 5000), // رصيد الحساب
            'current_balance' => rand(1000, 5000), // الرصيد الحالي
        ];
    }
}
