<?php

namespace App\Exports;

use App\Models\Competitor;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class CompetitorsExport implements FromCollection, WithHeadings
{
    protected $type;

    /**
     * Constructor to determine which type of data to export.
     *
     * @param string $type
     */
    public function __construct($type)
    {
        $this->type = $type;
    }

    /**
     * Return the collection based on the type.
     *
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {
        switch ($this->type) {
            case 'pending':
                return Competitor::where('status', 'pending')->get(['first_name', 'last_name', 'email', 'phone', 'strategy', 'photo']);
            case 'in_competition':
                return Competitor::where('status', 'in_competition')->get(['first_name', 'last_name', 'email', 'phone', 'strategy', 'account_balance', 'account_number']);
            case 'rejected':
                return Competitor::where('status', 'rejected')->get(['first_name', 'last_name', 'email', 'phone', 'strategy', 'rejection_reason']);
            default:
                return Competitor::all();
        }
    }

    /**
     * Define the headings for the Excel file.
     *
     * @return array
     */
    public function headings(): array
    {
        switch ($this->type) {
            case 'pending':
                return ['الاسم الأول', 'الاسم الثاني', 'البريد الإلكتروني', 'رقم الهاتف', 'الاستراتيجية', 'الصورة'];
            case 'in_competition':
                return ['الاسم الأول', 'الاسم الثاني', 'البريد الإلكتروني', 'رقم الهاتف', 'الاستراتيجية', 'رصيد الحساب', 'رقم الحساب'];
            case 'rejected':
                return ['الاسم الأول', 'الاسم الثاني', 'البريد الإلكتروني', 'رقم الهاتف', 'الاستراتيجية', 'سبب الرفض'];
            default:
                return ['الاسم الأول', 'الاسم الثاني', 'البريد الإلكتروني', 'رقم الهاتف', 'الاستراتيجية', 'الصورة', 'حالة الطلب', 'سبب الرفض', 'رقم الحساب', 'كلمة مرور التداول', 'رصيد الحساب', 'الرصيد الحالي'];
        }
    }
}
