<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Competition;
use App\Models\Competitor;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{
    /**
     * عرض لوحة التحكم مع الإحصائيات.
     */
    public function index()
    {
        // عدد المسابقات المتاحة
        $availableCompetitions = Competition::where('is_available', true)->count();

        // عدد المسابقات المكتملة
        $completedCompetitions = Competition::where('is_available', false)->count();

        // أكثر مسابقة بها اشتراكات
        $mostSubscribedCompetition = Competitor::select('competition_id', DB::raw('count(*) as total'))
            ->groupBy('competition_id')
            ->orderByDesc('total')
            ->first();

        if ($mostSubscribedCompetition) {
            $mostSubscribedCompetitionName = Competition::find($mostSubscribedCompetition->competition_id)->competition_name;
            $mostSubscribedCompetitionCount = $mostSubscribedCompetition->total;
        } else {
            $mostSubscribedCompetitionName = 'لا توجد مسابقات';
            $mostSubscribedCompetitionCount = 0;
        }

        // عدد المشاركين الكلين (الحالة = 'in_competition')
        $cleanParticipants = Competitor::where('status', Competitor::STATUS_IN_COMPETITION)->count();

        // عدد المرفوضين (الحالة = 'rejected' وليس سبب الرفض 'تم إنهاء المسابقة')
        $rejectedParticipants = Competitor::where('status', Competitor::STATUS_REJECTED)
            ->where('rejection_reason', '!=', 'تم إنهاء المسابقة.')
            ->count();

        return view('admin.dashboard', compact(
            'availableCompetitions',
            'completedCompetitions',
            'mostSubscribedCompetitionName',
            'mostSubscribedCompetitionCount',
            'cleanParticipants',
            'rejectedParticipants'
        ));
    }
}
