<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Competitor;
use Illuminate\Support\Facades\Mail;
use App\Mail\ParticipantRejected;
use App\Models\Competition; // إضافة هذا السطر

class ParticipantController extends Controller
{
    /**
     * عرض قائمة المتسابقين الحاليين.
     */
    public function current()
    {
        // جلب جميع المسابقات المتاحة لإظهارها في القائمة المنسدلة
        $competitions = Competition::where('is_available', true)->get();

        // جلب المتسابقين الحاليين (status = 'in_competition')
        $participants = Competitor::where('status', Competitor::STATUS_IN_COMPETITION)
            ->with('competition')
            ->get();

        return view('admin.participants.current', compact('competitions', 'participants'));
    }

    /**
     * عرض قائمة المتسابقين المكتملين.
     */
    public function completed()
    {
        // جلب المتسابقين المكتملين (status = 'rejected')
        $completedParticipants = Competitor::where('status', Competitor::STATUS_REJECTED)
            ->where('rejection_reason', '!=', 'تم إنهاء المسابقة.')
            ->with('competition')
            ->get();

        return view('admin.participants.completed', compact('completedParticipants'));
    }

    /**
     * رفض متسابق من القائمة الحالية مع سبب الرفض.
     */
    public function reject(Request $request, $id)
    {
        $request->validate([
            'rejection_reason' => 'required|string|max:255',
        ]);

        $competitor = Competitor::findOrFail($id);

        // تحديث حالة المتسابق
        $competitor->update([
            'status' => Competitor::STATUS_REJECTED,
            'rejection_reason' => $request->rejection_reason,
        ]);

        // إرسال بريد إلكتروني للرفض
        Mail::to($competitor->email)->send(new ParticipantRejected($competitor, $request->rejection_reason));

        return redirect()->back()->with('success', 'تم رفض المتسابق وإرسال رسالة رفض.');
    }

    /**
     * تعديل معلومات متسابق.
     */
    public function edit(Request $request, $id)
    {
        // يمكنك إضافة تفاصيل تعديل حسب الحاجة
        // على سبيل المثال، تعديل الاستراتيجية أو بيانات أخرى

        $request->validate([
            // قواعد التحقق حسب الحقول المراد تعديلها
            'strategy' => 'required|string',
            // أضف المزيد إذا لزم الأمر
        ]);

        $competitor = Competitor::findOrFail($id);

        // تحديث البيانات
        $competitor->update([
            'strategy' => $request->strategy,
            // أضف المزيد إذا لزم الأمر
        ]);

        return redirect()->back()->with('success', 'تم تعديل بيانات المتسابق بنجاح.');
    }
}
