<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Competitor;
use Illuminate\Support\Facades\Mail;
use App\Mail\RequestApproved;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Http;

class PendingRequestController extends Controller
{
    /**
     * عرض قائمة الطلبات المعلقة.
     */
    public function index()
    {
        // الطلبات المعلقة هي المتسابقين الذين لم تتم الموافقة عليهم أو رفضهم بعد
        $pendingRequests = Competitor::where('status', 'pending')->get();

        return view('admin.pending_requests.index', compact('pendingRequests'));
    }


    public function generateStrongPassword($length = 12)
{
    $upper = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $lower = 'abcdefghijklmnopqrstuvwxyz';
    $numbers = '0123456789';
    $special = '!@#$%^&*()_+-={}[]|:;<>,.?';
    $all = $upper . $lower . $numbers . $special;

    $password = '';
    $password .= $upper[rand(0, strlen($upper) - 1)];
    $password .= $lower[rand(0, strlen($lower) - 1)];
    $password .= $numbers[rand(0, strlen($numbers) - 1)];
    $password .= $special[rand(0, strlen($special) - 1)];

    for ($i = 4; $i < $length; $i++) {
        $password .= $all[rand(0, strlen($all) - 1)];
    }

    return str_shuffle($password);

}
    /**
     * الموافقة على طلب مع إنشاء رقم حساب وكلمة مرور تلقائيًا.
     */
    public function approve(Request $request, $id)
    {
        // العثور على المتسابق
        $competitor = Competitor::findOrFail($id);

        // توليد كلمة مرور قوية
        $password = $this->generateStrongPassword(8);

        // إعداد بيانات المستخدم لإرسالها إلى API
        $userData = [
            'first_name' => $competitor->first_name,
            'last_name' => $competitor->last_name,
            'phone' => $competitor->phone,
            // لا نرسل البريد الإلكتروني إلى API
            // 'email' => $competitor->email,
            'balance' => $competitor->competition->balance,
            'group' => $competitor->competition->trading_group,
            'password' => $password
        ];

        try {
            // إرسال طلب POST إلى API Python
            $response = Http::post('http://127.0.0.1:5000/create_account', $userData);

            \Log::info('API Response Status: ' . $response->status());
            \Log::info('API Response Body: ' . $response->body());

            if ($response->successful()) {
                $accountNumber = $response->json()['account_number'];

                // تحديث حالة المتسابق وحفظ تفاصيل الحساب
                $competitor->update([
                    'status' => Competitor::STATUS_IN_COMPETITION,
                    'account_number' => $accountNumber,
                    'trading_password' => bcrypt($password),
                ]);

                // إرسال بريد إلكتروني للعميل بمعلومات الحساب
                Mail::to($competitor->email)->send(new RequestApproved($competitor, $accountNumber, $password));

                return redirect()->back()->with('success', 'تمت الموافقة على الطلب وإرسال معلومات الحساب إلى العميل.');
            } else {
                \Log::error('API Error: ' . $response->body());
                return redirect()->back()->with('error', 'فشل في إنشاء الحساب عبر API.');
            }
        } catch (\Exception $e) {
            \Log::error('Exception: ' . $e->getMessage());
            return redirect()->back()->with('error', 'حدث خطأ أثناء إنشاء الحساب: ' . $e->getMessage());
        }
    }

    /**
     * رفض طلب مع سبب الرفض وإرسال البريد الإلكتروني.
     */
    public function reject(Request $request, $id)
    {
        // التحقق من صحة البيانات
        $request->validate([
            'rejection_reason' => 'required|string|max:255',
            'send_reason' => 'nullable|boolean',
        ]);

        // العثور على المتسابق
        $competitor = Competitor::findOrFail($id);

        // تحديث حالة المتسابق
        $competitor->update([
            'status' => Competitor::STATUS_REJECTED,
            'rejection_reason' => $request->rejection_reason,
        ]);

        // إذا تم تحديد إرسال سبب الرفض، إرسال بريد إلكتروني
        if ($request->has('send_reason') && $request->send_reason) {
            Mail::to($competitor->email)->send(new \App\Mail\RequestRejected($competitor, $request->rejection_reason));
        } else {
            Mail::to($competitor->email)->send(new \App\Mail\RequestRejected($competitor));
        }

        return redirect()->back()->with('success', 'تم رفض الطلب وإرسال رسالة رفض حسب الاختيار.');
    }
}
