<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class ProfileController extends Controller
{
    /**
     * عرض نموذج تغيير كلمة المرور.
     */
    public function showChangePasswordForm()
    {
        return view('admin.change-password');
    }

    /**
     * معالجة طلب تغيير كلمة المرور.
     */
    public function changePassword(Request $request)
    {
        // التحقق من صحة البيانات
        $request->validate([
            'current_password' => ['required', 'string', 'min:8'],
            'new_password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);

        // التحقق من صحة كلمة المرور الحالية
        if (!Hash::check($request->current_password, Auth::user()->password)) {
            return back()->withErrors(['current_password' => 'كلمة المرور الحالية غير صحيحة.']);
        }

        // تحديث كلمة المرور
        $user = Auth::user();
        $user->password = Hash::make($request->new_password);
        $user->save();

        // إعادة التوجيه مع رسالة نجاح
        return back()->with('success', 'تم تغيير كلمة المرور بنجاح.');
    }
}
