<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Competitor;
use Illuminate\Support\Facades\Mail;
use App\Mail\ApprovalMail;

class AdminController extends Controller
{
    // عرض لوحة الإدارة
    public function index()
    {
        $applications = Competitor::where('approved', false)->get();
        $approvedCompetitors = Competitor::where('approved', true)->get();

        return view('admin.dashboard', compact('applications', 'approvedCompetitors'));
    }

    // الموافقة على المتسابق
    public function approve(Request $request, $id)
    {
        // تحقق من البيانات المدخلة
        $request->validate([
            'account_number' => 'required',
            'trading_password' => 'required',
        ]);

        $competitor = Competitor::find($id);
        $competitor->account_number = $request->account_number;
        $competitor->trading_password = $request->trading_password;
        $competitor->approved = true;
        $competitor->save();

        // إرسال بريد إلكتروني للمتسابق
        Mail::to($competitor->email)->send(new ApprovalMail($competitor));

        return redirect()->back()->with('success', 'تمت الموافقة على المتسابق وإرسال البريد الإلكتروني.');
    }

    // تعديل بيانات المتسابق (اختياري)
    public function edit($id)
    {
        $competitor = Competitor::find($id);
        return view('admin.edit', compact('competitor'));
    }

    public function update(Request $request, $id)
    {
        // تحديث بيانات المتسابق
    }

    // حذف المتسابق (اختياري)
    public function destroy($id)
    {
        $competitor = Competitor::find($id);
        $competitor->delete();

        return redirect()->back()->with('success', 'تم حذف المتسابق بنجاح.');
    }
}
