<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Competition;

class CompetitionController extends Controller
{
    /**
     * جلب قائمة المسابقات مع المتسابقين.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        $competitions = Competition::where('is_available', true)
            ->with(['competitors' => function ($query) {
                $query->orderByDesc('account_balance')->paginate(10);
            }])
            ->get();

        return response()->json($competitions);
    }
}
