<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Competitor;
use Illuminate\Support\Facades\Mail;
use App\Mail\ApprovalMail;

class ApplicationController extends Controller
{
    // تخزين بيانات المتسابق
    public function store(Request $request)
    {
        // تحقق من البيانات المدخلة
        $request->validate([
            'first_name' => 'required',
            'last_name' => 'required',
            'email' => 'required|email|unique:competitors,email',
            'phone' => 'required',
            'strategy' => 'required',
            'photo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        // حفظ الصورة
        $imageName = time().'.'.$request->photo->extension();
        $request->photo->move(public_path('images'), $imageName);

        // إنشاء متسابق جديد
        Competitor::create([
            'first_name' => $request->first_name,
            'last_name' => $request->last_name,
            'email' => $request->email, // إضافة حقل email
            'phone' => $request->phone,
            'strategy' => $request->strategy,
            'photo' => $imageName,
            // الحقول الأخرى ستكون بقيم افتراضية أو قابلة للملء لاحقًا
        ]);

        // إعادة التوجيه مع رسالة نجاح
        return redirect('/')->with('success', 'تم تقديم طلبك بنجاح!');
    }
}
