<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    /**
     * عرض نموذج تسجيل الدخول.
     */
    public function showLoginForm()
    {
        return view('auth.login'); // تأكد من وجود الملف resources/views/auth/login.blade.php
    }

    /**
     * معالجة طلب تسجيل الدخول.
     */
    public function login(Request $request)
    {
        // التحقق من صحة البيانات
        $request->validate([
            'email' => 'required|email',
            'password' => 'required',
        ]);

        // محاولة تسجيل الدخول
        if (Auth::attempt(['email' => $request->email, 'password' => $request->password])) {
            // إذا نجح، إعادة التوجيه إلى لوحة الإدارة
            return redirect()->intended('admin/dashboard');
        }

        // إذا فشل، إعادة التوجيه مع رسالة خطأ
        return back()->withInput($request->only('email'))->withErrors([
            'email' => 'بيانات الاعتماد غير صحيحة.',
        ]);
    }

    /**
     * تسجيل الخروج.
     */
    public function logout(Request $request)
    {
        Auth::logout();

        $request->session()->invalidate();

        $request->session()->regenerateToken();

        return redirect('admin/login');
    }
}
