<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Competition;

class BalanceController extends Controller
{
    public function getAccountBalances()
    {
        try {
            $competitions = Competition::with(['competitors' => function ($query) {
                $query->where('status', 'in_competition') // جلب المتسابقين الذين هم في المسابقة فقط
                    ->select('id', 'competition_id', 'account_balance', 'first_name', 'last_name', 'photo');
            }])->get(['id', 'competition_name', 'balance']);

            $competitions = $competitions->map(function($competition) {
                $competition->competitors = $competition->competitors->map(function($competitor) use ($competition) {
                    // حساب العائد بناءً على الرصيد الابتدائي للمسابقة
                    $competitor->account_return = $competition->balance > 0
                        ? (($competitor->account_balance / $competition->balance) - 1) * 100
                        : 0;
                    return $competitor;
                });
                return $competition;
            });

            return response()->json($competitions, 200);
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 500);
        }
    }
}
