<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Competition;

class CompetitionController extends Controller

{
    
    /**
     * عرض نموذج إنشاء مسابقة جديدة.
     */
    public function create()
    {
        return view('competitions.create');
    }

    /**
     * تخزين مسابقة جديدة في قاعدة البيانات.
     */
    public function store(Request $request)
    {
        $request->validate([
            'competition_name' => 'required|string|max:255',
            'is_available'     => 'required|boolean',
            'balance'          => 'required|numeric|min:0',
            'gift'             => 'required|string|max:255',
            'submission_end_date' => 'required|date|after:now',
            'competition_end_date' => 'required|date|after:submission_end_date',
        ]);

        Competition::create([
            'competition_name'      => $request->competition_name,
            'is_available'          => $request->is_available,
            'balance'               => $request->balance,
            'gift'                  => $request->gift,
            'submission_end_date'   => $request->submission_end_date,
            'competition_end_date'  => $request->competition_end_date,
        ]);

        return redirect()->route('competitions.index')->with('success', 'تم إنشاء المسابقة بنجاح.');
    }

    /**
     * عرض نموذج تعديل مسابقة.
     */
    public function edit(Competition $competition)
    {
        return view('competitions.edit', compact('competition'));
    }


    /**
     * تحديث مسابقة في قاعدة البيانات.
     */
    public function update(Request $request, Competition $competition)
    {
        $request->validate([
            'competition_name' => 'required|string|max:255',
            'is_available'     => 'required|boolean',
            'balance'          => 'required|numeric|min:0',
            'gift'             => 'required|string|max:255',
            'submission_end_date' => 'required|date|after:now',
            'competition_end_date' => 'required|date|after:submission_end_date',
        ]);

        $competition->update([
            'competition_name'      => $request->competition_name,
            'is_available'          => $request->is_available,
            'balance'               => $request->balance,
            'gift'                  => $request->gift,
            'submission_end_date'   => $request->submission_end_date,
            'competition_end_date'  => $request->competition_end_date,
        ]);

        return redirect()->route('competitions.index')->with('success', 'تم تحديث المسابقة بنجاح.');
    }

    /**
     * باقي دوال الـ Controller...
     */
}
