<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Competition;
use App\Models\Competitor;

class HomeController extends Controller
{
    /**
     * عرض الصفحة الرئيسية مع قائمة المسابقات والمتسابقين المفلترين.
     *
     * @return \Illuminate\View\View
     */
    public function index()
    {
        // جلب المسابقات المتاحة
        $competitions = Competition::where('is_available', true)->get();

        // لكل مسابقة، جلب المتسابقين المفلترين مع Pagination
        foreach ($competitions as $competition) {
            $competition->competitors_paginated = $competition->competitors()
                ->inCompetition() // استخدام النطاق المضاف سابقًا
                ->orderByDesc('account_balance') // ترتيب المتسابقين حسب رصيد الحساب تنازليًا
                ->paginate(10, ['*'], 'page_' . $competition->id); // 10 متسابقين لكل صفحة، مع تمييز اسم معلمة الصفحة لكل مسابقة
        }

        // جلب آخر 3 فائزين من قاعدة البيانات
        $latestWinners = Competitor::where('rejection_reason', 'الفائز')
            ->orderBy('updated_at', 'desc')
            ->take(3)
            ->get();

        return view('home', compact('competitions', 'latestWinners')); // تمرير 'latestWinners' إلى الـ View
    }
}
