<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        // التحقق مما إذا كان المستخدم مسجلاً الدخول ولديه صلاحية Admin
        if (Auth::check() && Auth::user()->is_admin) {
            return $next($request);
        }

        // إذا لم يكن Admin، إعادة التوجيه إلى الصفحة الرئيسية مع رسالة خطأ
        return redirect('/')->with('error', 'ليس لديك صلاحية الوصول إلى هذه الصفحة.');
    }
}
