<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class RestrictLoginIP
{
    /**
     * عناوين IP المسموح بها.
     *
     * @var array
     */
    protected $allowedIps = [
        '127.0.0.1',
        '89.147.102.38',
        '75.119.132.250', // استبدل هذا بعنوان IP المسموح
        // يمكنك إضافة المزيد من عناوين IP إذا لزم الأمر
    ];

    /**
     * معالجة الطلب الوارد.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        if (!in_array($request->ip(), $this->allowedIps)) {
            abort(403, 'غير مصرح لك بالوصول إلى هذه الصفحة.');
        }

        return $next($request);
    }
}
