<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreCompetitorRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true; // يمكنك تعديل هذا حسب الحاجة
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'first_name' => 'required|string|max:255',
            'last_name'  => 'required|string|max:255',
            'email'      => 'required|email|unique:competitors,email',
            'phone'      => 'required|string|max:20',
            'strategy'   => 'required|string',
            'photo'      => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
            'terms'      => 'accepted', // التحقق من الموافقة على الشروط
        ];
    }

    /**
     * تخصيص رسائل الخطأ.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'terms.accepted' => 'يجب عليك الموافقة على الشروط والأحكام قبل تقديم الطلب.',
        ];
    }
}
