<?php

namespace App\Mail;

use App\Models\Competitor;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ApplicationRejected extends Mailable
{
    use Queueable, SerializesModels;

    public $competitor;

    /**
     * Create a new message instance.
     *
     * @param \App\Models\Competitor $competitor
     */
    public function __construct(Competitor $competitor)
    {
        $this->competitor = $competitor;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
       return $this->subject('تم رفض طلبك للمسابقة')
                   ->view('emails.application_rejected');
    }
}
