<?php

namespace App\Mail;

use App\Models\Competitor;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ApprovalMail extends Mailable
{
    use Queueable, SerializesModels;

    public $competitor;

    public function __construct(Competitor $competitor)
    {
        $this->competitor = $competitor;
    }

    public function build()
    {
        return $this->subject('مبروك! تم قبول طلبك')
                    ->view('emails.approval');
    }
}
