<?php

namespace App\Mail;

use App\Models\Competitor;
use App\Models\Competition;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CompetitionEnded extends Mailable
{
    use Queueable, SerializesModels;

    public $competitor;
    public $competition;

    /**
     * Create a new message instance.
     */
    public function __construct(Competitor $competitor, Competition $competition)
    {
        $this->competitor = $competitor;
        $this->competition = $competition;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('مبروك! لقد فزت في المسابقة')
                    ->markdown('emails.competitions.ended');
    }
}
