<?php

namespace App\Mail;

use App\Models\Competitor;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CompetitorRejected extends Mailable
{
    use Queueable, SerializesModels;

    public $competitor;

    /**
     * Create a new message instance.
     */
    public function __construct(Competitor $competitor)
    {
        $this->competitor = $competitor;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->subject('خروجك من المسابقة بسبب الوصول إلى الستوب المحدد')
                    ->markdown('emails.competitions.rejected');
    }
}
