<?php

namespace App\Mail;

use App\Models\Competitor;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ParticipantRejected extends Mailable
{
    use Queueable, SerializesModels;

    public $competitor;
    public $rejectionReason;

    /**
     * إنشاء رسالة جديدة.
     */
    public function __construct(Competitor $competitor, $rejectionReason)
    {
        $this->competitor = $competitor;
        $this->rejectionReason = $rejectionReason;
    }

    /**
     * بناء الرسالة.
     */
    public function build()
    {
        return $this->subject('تم رفض مشاركتك في المسابقة')
                    ->markdown('emails.participant_rejected');
    }
}
