<?php

namespace App\Mail;

use App\Models\Competitor;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RequestApproved extends Mailable
{
    use Queueable, SerializesModels;

    public $competitor;
    public $accountNumber;
    public $password;

    /**
     * إنشاء رسالة جديدة.
     */
    public function __construct(Competitor $competitor, $accountNumber, $password)
    {
        $this->competitor = $competitor;
        $this->accountNumber = $accountNumber;
        $this->password = $password;
    }

    /**
     * بناء الرسالة.
     */
    public function build()
    {
        return $this->subject('تمت الموافقة على طلبك في المسابقة')
                    ->markdown('emails.request_approved')
                    ->with([
                        'competitor' => $this->competitor,
                        'accountNumber' => $this->accountNumber,
                        'password' => $this->password,
                    ]);
    }
}
