<?php

namespace App\Mail;

use App\Models\Competitor;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class RequestRejected extends Mailable
{
    use Queueable, SerializesModels;

    public $competitor;
    public $rejectionReason;

    /**
     * إنشاء رسالة جديدة.
     */
    public function __construct(Competitor $competitor, $rejectionReason = null)
    {
        $this->competitor = $competitor;
        $this->rejectionReason = $rejectionReason;
    }

    /**
     * بناء الرسالة.
     */
    public function build()
    {
        return $this->subject('تم رفض طلبك في المسابقة')
                    ->markdown('emails.request_rejected')
                    ->with([
                        'competitor' => $this->competitor,
                        'rejectionReason' => $this->rejectionReason,
                    ]);
    }
}
