<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Competition extends Model
{
    use HasFactory;


    protected $fillable = [
        'competition_name',
        'is_available',
        'balance',
        'gift',
        'submission_end_date', // تاريخ انتهاء التقديم
        'competition_end_date', // تاريخ انتهاء المسابقة
        'account_type',  // نوع الحساب
        'trading_group',   // كروب التداول
        'has_stop',       // جديد
        'stop_amount',    // جديد
        'processed', 
    ];

    /**
     * علاقة المسابقة بالمتسابقين.
     */
    public function competitors()
    {
        return $this->hasMany(Competitor::class);
    }
}
