<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Competitor extends Model
{
    use HasFactory;

    const STATUS_PENDING = 'pending';
    const STATUS_IN_COMPETITION = 'in_competition';
    const STATUS_REJECTED = 'rejected';
    const STATUS_WON = 'won';

    protected $fillable = [
        'first_name',
        'last_name',
        'phone',
        'strategy',
        'email',
        'photo',
        'account_balance',
        'current_balance',
        'account_number',
        'trading_password',
        'status',
        'competition_id',
        'rejection_reason',
        
    ];

    /**
 * Scope a query to only include competitors in competition.
 *
 * @param \Illuminate\Database\Eloquent\Builder $query
 * @return \Illuminate\Database\Eloquent\Builder
 */
    public function scopeInCompetition($query)
{
    return $query->where('status', 'in_competition');
}
    /**
     * علاقة المتسابق بالمسابقة.
     */
    public function competition()
    {
        return $this->belongsTo(Competition::class);
    }

    /**
     * حساب عائد الحساب كنسبة مئوية بناءً على رصيد المسابقة.
     *
     * @return float
     */
    public function accountReturn()
    {
        if ($this->competition->balance > 0) {
            return ($this->account_balance / $this->competition->balance) * 100;
        }
        return 0;
    }
}
