-- Backup of database `competition_system`
-- Date: 2024-10-18 12:40:33

CREATE TABLE `competitions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `competition_name` varchar(255) NOT NULL,
  `is_available` tinyint(1) NOT NULL DEFAULT 1,
  `balance` decimal(15,2) NOT NULL DEFAULT 0.00,
  `gift` varchar(255) NOT NULL,
  `submission_end_date` datetime DEFAULT NULL,
  `competition_end_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `competitions` (`id`, `competition_name`, `is_available`, `balance`, `gift`, `submission_end_date`, `competition_end_date`, `created_at`, `updated_at`) VALUES (3, 'افضل متداول للحسابات تجريبية لشهر 10', 1, 500.00, '200', '2024-10-20 23:59:00', '2024-10-31 23:59:00', '2024-10-17 12:11:52', '2024-10-17 12:13:24');

CREATE TABLE `competitors` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `strategy` varchar(255) NOT NULL,
  `photo` varchar(255) NOT NULL,
  `account_balance` decimal(10,2) NOT NULL DEFAULT 0.00,
  `current_balance` decimal(10,2) NOT NULL DEFAULT 0.00,
  `status` enum('pending','in_competition','rejected') NOT NULL DEFAULT 'pending',
  `rejection_reason` text DEFAULT NULL,
  `account_number` varchar(255) DEFAULT NULL,
  `trading_password` varchar(255) DEFAULT NULL,
  `competition_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `competitors_competition_id_foreign` (`competition_id`),
  CONSTRAINT `competitors_competition_id_foreign` FOREIGN KEY (`competition_id`) REFERENCES `competitions` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (1, '2014_10_12_000000_create_users_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (2, '2014_10_12_100000_create_password_reset_tokens_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (3, '2019_08_19_000000_create_failed_jobs_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (4, '2019_12_14_000001_create_personal_access_tokens_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (5, '2024_10_11_104122_create_competitors_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (6, '2014_10_12_100000_create_password_resets_table', 2);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (7, '2024_10_11_122028_add_is_admin_to_users_table', 2);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (8, '2024_10_11_125111_add_email_to_competitors_table', 3);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (9, '2024_10_11_153627_add_status_and_rejection_reason_to_competitors_table', 4);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (10, '2024_10_15_103004_remove_approved_from_competitors_table', 5);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (11, '2024_10_15_103022_create_competitions_table', 6);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (12, '2024_10_15_103252_add_competition_id_to_competitors_table', 7);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (13, '2024_10_15_105148_add_unique_email_competition_to_competitors_table', 8);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (14, '2024_10_15_110624_modify_competitors_table_unique_email_competition', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (15, '2024_10_15_114418_add_balance_to_competitions_table', 9);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (16, '2024_10_15_140352_add_gift_to_competitions_table', 10);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (17, '2024_10_15_141351_change_gift_column_type_in_competitions_table', 11);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES (18, '2024_10_15_142606_add_end_dates_to_competitions_table', 12);

CREATE TABLE `password_reset_tokens` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `is_admin` tinyint(1) NOT NULL DEFAULT 0,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `users` (`id`, `name`, `email`, `email_verified_at`, `password`, `is_admin`, `remember_token`, `created_at`, `updated_at`) VALUES (1, 'Admin Name', 'dev@ri-fx.com', NULL, '$2y$12$Oy0yj6pgoBeOmoxzh3T4ludhBWHClEyUpQp6YO0Hk7JjkZsbEAm/e', 1, NULL, '2024-10-11 12:20:57', '2024-10-15 21:45:32');

