<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStatusAndRejectionReasonToCompetitorsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('competitors', function (Blueprint $table) {
            $table->enum('status', ['pending', 'in_competition', 'rejected'])->default('pending')->after('current_balance');
            $table->text('rejection_reason')->nullable()->after('status');
            $table->string('trading_password')->nullable()->change(); // تأكد من أن الحقل قابل للترميز لاحقًا
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('competitors', function (Blueprint $table) {
            $table->dropColumn(['status', 'rejection_reason']);
            // أعادة تعريف الحقل إذا كان تم تغييره
            $table->string('trading_password')->nullable(false)->change();
        });
    }
}
