<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class ModifyCompetitorsTableUniqueEmailCompetition extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('competitors', function (Blueprint $table) {
            // **خطوة أولى**: إزالة القيد الفريد الحالي على حقل email إذا كان موجودًا
            // استخدام try-catch لتجنب الخطأ إذا كان القيد غير موجود
            try {
                $table->dropUnique('competitors_email_unique');
            } catch (\Exception $e) {
                // القيد غير موجود، لا حاجة لفعل شيء
            }

            // **خطوة ثانية**: إضافة قيد فريد مركب على email و competition_id إذا لم يكن موجودًا
            $indexes = DB::select('SHOW INDEXES FROM competitors');
            $indexExists = false;
            foreach ($indexes as $index) {
                if ($index->Key_name === 'unique_email_competition') {
                    $indexExists = true;
                    break;
                }
            }

            if (!$indexExists) {
                $table->unique(['email', 'competition_id'], 'unique_email_competition');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('competitors', function (Blueprint $table) {
            // إزالة القيد الفريد المركب إذا كان موجودًا
            try {
                $table->dropUnique('unique_email_competition');
            } catch (\Exception $e) {
                // القيد غير موجود، لا حاجة لفعل شيء
            }

            // إعادة إضافة القيد الفريد على email إذا لزم الأمر
            $indexes = DB::select('SHOW INDEXES FROM competitors');
            $indexExists = false;
            foreach ($indexes as $index) {
                if ($index->Key_name === 'competitors_email_unique') {
                    $indexExists = true;
                    break;
                }
            }

            if (!$indexExists) {
                $table->unique('email', 'competitors_email_unique');
            }
        });
    }
}
