<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class ChangeGiftColumnTypeInCompetitionsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('competitions', function (Blueprint $table) {
            // تغيير نوع العمود من decimal إلى string
            $table->string('gift', 255)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('competitions', function (Blueprint $table) {
            // إعادة نوع العمود إلى decimal إذا لزم الأمر
            $table->decimal('gift', 15, 2)->default(0)->change();
        });
    }
}
