<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddEndDatesToCompetitionsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('competitions', function (Blueprint $table) {
            $table->dateTime('submission_end_date')->nullable()->after('gift'); // تاريخ انتهاء التقديم
            $table->dateTime('competition_end_date')->nullable()->after('submission_end_date'); // تاريخ انتهاء المسابقة
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('competitions', function (Blueprint $table) {
            $table->dropColumn(['submission_end_date', 'competition_end_date']);
        });
    }
}
