<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddStopColumnsToCompetitionsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('competitions', function (Blueprint $table) {
            $table->boolean('has_stop')->default(false)->after('competition_end_date')->comment('هل يوجد ستوب؟');
            $table->decimal('stop_amount', 10, 2)->nullable()->after('has_stop')->comment('مقدار الستور أو الخسارة ($)');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('competitions', function (Blueprint $table) {
            $table->dropColumn(['has_stop', 'stop_amount']);
        });
    }
}
