<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddProcessedToCompetitionsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('competitions', function (Blueprint $table) {
            $table->boolean('processed')->default(false)->after('competition_end_date')->comment('هل تم معالجة المسابقة المنتهية؟');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('competitions', function (Blueprint $table) {
            $table->dropColumn('processed');
        });
    }
}
