// resources/js/competition.js

document.addEventListener('DOMContentLoaded', function () {
    const competitionSelect = document.getElementById('competition_id');
    const competitionInfo = document.getElementById('competition-info');
    const competitionName = document.getElementById('selected-competition-name');
    const competitionGift = document.getElementById('selected-competition-gift');
    const competitionEnd = document.getElementById('selected-competition-end');
    const stopAmount = document.getElementById('selected-stop-amount');
    const stopAmountContainer = document.getElementById('stop-amount-container');
    const accountBalance = document.getElementById('selected-account-balance');

    competitionSelect.addEventListener('change', function () {
        const selectedOption = this.options[this.selectedIndex];
        const gift = selectedOption.getAttribute('data-gift');
        const competitionEndDate = selectedOption.getAttribute('data-competition-end');
        const balance = selectedOption.getAttribute('data-balance');
        const stopAmt = selectedOption.getAttribute('data-stop-amount');

        if (this.value) {
            // تحديث معلومات المسابقة
            competitionName.textContent = selectedOption.textContent;
            competitionGift.textContent = gift;
            competitionEnd.textContent = competitionEndDate;
            accountBalance.textContent = '$' + balance;

            if (stopAmt) {
                stopAmount.textContent = stopAmt;
                stopAmountContainer.classList.remove('d-none'); // إظهار أقصى خسارة
            } else {
                stopAmount.textContent = '';
                stopAmountContainer.classList.add('d-none'); // إخفاء أقصى خسارة
            }

            competitionInfo.style.display = 'block';
        } else {
            competitionInfo.style.display = 'none';
        }

        // Debugging logs
        console.log('Competition Selected:', selectedOption.textContent);
        console.log('Gift:', gift);
        console.log('Competition End Date:', competitionEndDate);
        console.log('Account Balance:', balance);
        console.log('Stop Amount:', stopAmt);
    });

    // تم إزالة دالة translateCompetitionType لأنها غير ضرورية الآن
});
