// Load external scripts dynamically
function loadScripts(urls) {
    return Promise.all(urls.map((url) => {
        return new Promise((resolve, reject) => {
            const script = document.createElement('script');
            script.src = url;
            script.async = true;
            script.onload = resolve;
            script.onerror = reject;
            document.head.appendChild(script);
        });
    }));
}

// Load jQuery and DataTables libraries
loadScripts([
    'https://code.jquery.com/jquery-3.6.0.min.js',
    'https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js',
    'https://cdn.datatables.net/1.10.25/js/dataTables.bootstrap5.min.js',
    'https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js' // Bootstrap JS
]).then(() => {
    $(document).ready(function() {
        // Initialize DataTable
        var table = $('#currentParticipantsTable').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            },
            "searching": true,
            "ordering": true,
            "paging": true,
            "columnDefs": [
                { "targets": 10, "visible": false } // إخفاء عمود "Competition ID"
            ]
        });

        // Filter table based on selected competition
        $('#filterCompetition').on('change', function(){
            var competitionId = $(this).val();
            if (competitionId) {
                table.column(10).search('^' + competitionId + '$', true, false).draw();
            } else {
                table.column(10).search('').draw();
            }
        });
    });
}).catch((error) => {
    console.error("Error loading scripts:", error);
});
