// تضمين SweetAlert2 و DataTables و jQuery عبر Import في البداية، إذا كان هذا ضرورياً في نظام التثبيت
import 'sweetalert2';
import 'datatables.net-bs5';
import $ from 'jquery';

document.addEventListener('DOMContentLoaded', function () {
    if (window.competitions) {
        window.competitions.forEach((competition) => {
            $('#competitorsTable' + competition.id).DataTable({
                "paging": false,
                "info": false,
                "searching": false,
                "order": [[3, "desc"]]
            });
        });
    }

    function fetchCompetitors() {
        $.ajax({
            url: "/competitors/current-balances",
            method: 'GET',
            success: function(data) {
                updateCompetitorsData(data);
            },
            error: function(error) {
                console.error('Error fetching competitors:', error);
            }
        });
    }

    function updateCompetitorsData(data) {
        data.forEach(competition => {
            const competitors = competition.competitors;
            competitors.sort((a, b) => b.account_return - a.account_return);

            const tableId = '#competitorsTable' + competition.id;
            const $tableBody = $(tableId + ' tbody');
            $tableBody.empty();

            competitors.forEach((competitor, index) => {
                const firstName = competitor.first_name || 'الاسم غير متوفر';
                const lastName = competitor.last_name || 'الاسم غير متوفر';
                const photoUrl = competitor.photo ? `/images/${competitor.photo}` : '/images/default.png';

                const $row = $('<tr>').attr('data-competitor-id', competitor.id);
                $row.append(`<td>${index + 1}</td>`);
                $row.append(`
                    <td>
                        ${index === 0 ? '<i class="fas fa-trophy" title="المركز الأول" style="color: gold; margin-right: 5px;"></i>' : ''}
                        <img src="${photoUrl}" class="competitor-photo" alt="${firstName} ${lastName}" style="width: 60px; height: 60px; object-fit: cover; border-radius: 50%;" />
                    </td>`);
                $row.append(`<td>${firstName} ${lastName}</td>`);
                $row.append(`<td class="account-return">${parseFloat(competitor.account_return).toFixed(2)}%</td>`);
                $row.append(`<td class="account-balance">$${parseFloat(competitor.account_balance).toFixed(2)}</td>`);

                $tableBody.append($row);
            });
        });
    }


    setInterval(fetchCompetitors, 5000);
});
