@extends('layouts.admin')

@section('title', 'إدارة المسابقات')

@section('content')
<div class="container mt-5">
    <h2>إدارة المسابقات</h2>

    <!-- عرض رسالة النجاح -->
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <!-- زر إضافة مسابقة جديدة -->
    <div class="mb-4">
        <a href="{{ route('competitions.create') }}" class="btn btn-success">إضافة مسابقة جديدة</a>
    </div>

    <!-- قسم المسابقات الحالية -->
    <div class="card mb-4">
        <div class="card-header">
            <h4>المسابقات الحالية</h4>
        </div>
        <div class="card-body">
            @if($currentCompetitions->isEmpty())
                <p>لا توجد مسابقات حالية.</p>
            @else
                <table class="table table-striped table-bordered" id="currentCompetitionsTable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>اسم المسابقة</th>
                            <th>نوع الحساب</th>
                            <th>كروب التداول</th>
                            <th>متاحة</th>
                            <th>الرصيد البدائي</th>
                            <th>الجائزة</th>
                            <th>هل يوجد ستوب؟</th> <!-- جديد -->
                            <th>مقدار الستور أو الخسارة ($)</th> <!-- جديد -->
                            <th>تاريخ انتهاء التقديم</th>
                            <th>تاريخ انتهاء المسابقة</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($currentCompetitions as $index => $competition)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $competition->competition_name }}</td>
                                <td>{{ ucfirst($competition->account_type) }}</td>
                                <td>{{ $competition->trading_group }}</td>
                                <td>{{ $competition->is_available ? 'نعم' : 'لا' }}</td>
                                <td>${{ number_format($competition->balance, 2) }}</td>
                                <td>
                                    @if(is_numeric($competition->gift))
                                        ${{ number_format($competition->gift, 2) }}
                                    @else
                                        {{ $competition->gift }}
                                    @endif
                                </td>
                                <td>{{ $competition->has_stop ? 'نعم' : 'لا' }}</td> <!-- جديد -->
                                <td>
                                    @if($competition->has_stop)
                                        ${{ number_format($competition->stop_amount, 2) }}
                                    @else
                                        ---
                                    @endif
                                </td> <!-- جديد -->
                                <td>{{ \Carbon\Carbon::parse($competition->submission_end_date)->format('d-m-Y H:i') }}</td>
                                <td>{{ \Carbon\Carbon::parse($competition->competition_end_date)->format('d-m-Y H:i') }}</td>
                                <td>
                                    <a href="{{ route('competitions.edit', $competition->id) }}" class="btn btn-primary btn-sm">تعديل</a>
                                    <form action="{{ route('competitions.destroy', $competition->id) }}" method="POST" style="display:inline-block;">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من إنهاء هذه المسابقة؟')">إنهاء</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif
        </div>
    </div>

    <!-- قسم المسابقات المنتهية -->
    <div class="card mb-4">
        <div class="card-header">
            <h4>المسابقات المنتهية</h4>
        </div>
        <div class="card-body">
            @if($endedCompetitions->isEmpty())
                <p>لا توجد مسابقات منتهية.</p>
            @else
                <table class="table table-striped table-bordered" id="endedCompetitionsTable">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>اسم المسابقة</th>
                            <th>نوع الحساب</th>
                            <th>كروب التداول</th>
                            <th>متاحة</th>
                            <th>الرصيد البدائي</th>
                            <th>الجائزة</th>
                            <th>هل يوجد ستوب؟</th> <!-- جديد -->
                            <th>مقدار الستور أو الخسارة ($)</th> <!-- جديد -->
                            <th>تاريخ انتهاء التقديم</th>
                            <th>تاريخ انتهاء المسابقة</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($endedCompetitions as $index => $competition)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $competition->competition_name }}</td>
                                <td>{{ ucfirst($competition->account_type) }}</td>
                                <td>{{ $competition->trading_group }}</td>
                                <td>{{ $competition->is_available ? 'نعم' : 'لا' }}</td>
                                <td>${{ number_format($competition->balance, 2) }}</td>
                                <td>
                                    @if(is_numeric($competition->gift))
                                        ${{ number_format($competition->gift, 2) }}
                                    @else
                                        {{ $competition->gift }}
                                    @endif
                                </td>
                                <td>{{ $competition->has_stop ? 'نعم' : 'لا' }}</td> <!-- جديد -->
                                <td>
                                    @if($competition->has_stop)
                                        ${{ number_format($competition->stop_amount, 2) }}
                                    @else
                                        ---
                                    @endif
                                </td> <!-- جديد -->
                                <td>{{ \Carbon\Carbon::parse($competition->submission_end_date)->format('d-m-Y H:i') }}</td>
                                <td>{{ \Carbon\Carbon::parse($competition->competition_end_date)->format('d-m-Y H:i') }}</td>
                                <td>
                                    <a href="{{ route('competitions.edit', $competition->id) }}" class="btn btn-primary btn-sm">تعديل</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            @endif
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.25/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function() {
        $('#currentCompetitionsTable').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            },
            "searching": true,
            "ordering": true,
            "paging": true
        });

        $('#endedCompetitionsTable').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            },
            "searching": true,
            "ordering": true,
            "paging": true
        });
    });
</script>
@endpush
