@extends('layouts.admin') <!-- استخدام تخطيط الإدمن المخصص -->

@section('title', 'المتسابقون المكتملون')
@vite(['resources/js/currentParticipants.js'])
@section('content')
<div class="container mt-5">
    <h2>المتسابقون المكتملون</h2>

    <!-- عرض رسالة النجاح -->
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <!-- جدول المتسابقين المكتملين -->
    @if($completedParticipants->isEmpty())
        <p>لا توجد متسابقين مكتملين.</p>
    @else
        <table class="table table-striped table-bordered" id="completedParticipantsTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>تاريخ الاكتمال</th>
                    <th>الصورة</th>
                    <th>الاسم</th>
                    <th>رقم الهاتف</th>
                    <th>البريد الإلكتروني</th>
                    <th>الاستراتيجية</th>
                    <th>رصيد الحساب</th>
                    <th>رقم الحساب</th>
                    <th>سبب الرفض</th> <!-- إزالة عمود كلمة المرور -->
                </tr>
            </thead>
            <tbody>
                @foreach($completedParticipants as $index => $participant)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ \Carbon\Carbon::parse($participant->updated_at)->format('d-m-Y H:i') }}</td>
                        <td>
                            <img src="{{ asset('images/' . $participant->photo) }}" alt="{{ $participant->first_name }} {{ $participant->last_name }}" width="60" height="60" class="rounded-circle">
                        </td>
                        <td>{{ $participant->first_name }} {{ $participant->last_name }}</td>
                        <td>{{ $participant->phone }}</td>
                        <td>{{ $participant->email }}</td>
                        <td>{{ $participant->strategy }}</td>
                        <td>${{ number_format($participant->account_balance, 2) }}</td>
                        <td>{{ $participant->account_number }}</td>
                        <td>{{ $participant->rejection_reason }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</div>
@endsection

@push('styles')
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.25/css/dataTables.bootstrap5.min.css">
@endpush

@push('scripts')
<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.25/js/dataTables.bootstrap5.min.js"></script>
@endpush
