@extends('layouts.admin')

@section('title', 'المتسابقون الحاليون')
@vite(['resources/css/currentParticipants.css', 'resources/js/currentParticipants.js'])

@section('content')
<div class="container mt-5">
    <h2>المتسابقون الحاليون</h2>

    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <div class="mb-4">
        <label for="filterCompetition" class="form-label">اختر المسابقة</label>
        <select class="form-select" id="filterCompetition">
            <option value="">كل المسابقات</option>
            @foreach($competitions as $competition)
                <option value="{{ $competition->id }}">{{ $competition->competition_name }}</option>
            @endforeach
        </select>
    </div>

    <table class="table table-striped table-bordered" id="currentParticipantsTable">
        <thead>
            <tr>
                <th>#</th>
                <th>تاريخ الدخول</th>
                <th>الصورة</th>
                <th>الاسم</th>
                <th>رقم الهاتف</th>
                <th>البريد الإلكتروني</th>
                <th>الاستراتيجية</th>
                <th>رصيد الحساب</th>
                <th>رقم الحساب</th>
                <th>الإجراءات</th>
                <th style="display: none;">Competition ID</th>
            </tr>
        </thead>
        <tbody>
            @foreach($participants as $index => $participant)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ \Carbon\Carbon::parse($participant->updated_at)->format('d-m-Y H:i') }}</td>
                    <td><img src="{{ asset('images/' . $participant->photo) }}" alt="{{ $participant->first_name }} {{ $participant->last_name }}" class="rounded-circle"></td>
                    <td>{{ $participant->first_name }} {{ $participant->last_name }}</td>
                    <td>{{ $participant->phone }}</td>
                    <td>{{ $participant->email }}</td>
                    <td>{{ $participant->strategy }}</td>
                    <td>${{ number_format($participant->account_balance, 2) }}</td>
                    <td>{{ $participant->account_number }}</td>
                    <td>
                        <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#rejectModal{{ $participant->id }}">رفض</button>
                        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editModal{{ $participant->id }}">تعديل</button>
                    </td>
                    <td style="display: none;">{{ $participant->competition_id }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
