@extends('layouts.admin')

@section('title', 'الطلبات المعلقة')

@section('content')
<div class="container mt-5">
    <h2>الطلبات المعلقة</h2>

    @if(session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    @if($pendingRequests->isEmpty())
        <p>لا توجد طلبات معلقة.</p>
    @else
        <table class="table table-striped table-bordered" id="pendingRequestsTable">
            <thead>
                <tr>
                    <th>#</th>
                    <th>تاريخ الطلب</th>
                    <th>الصورة</th>
                    <th>الاسم</th>
                    <th>رقم الهاتف</th>
                    <th>البريد الإلكتروني</th>
                    <th>الاستراتيجية</th>
                    <th>المسابقة</th>
                    <th>نوع الحساب</th>
                    <th>كروب التداول</th>
                    <th>الإجراءات</th>
                </tr>
            </thead>
            <tbody>
                @foreach($pendingRequests as $index => $request)
                    <tr>
                        <td>{{ $index + 1 }}</td>
                        <td>{{ \Carbon\Carbon::parse($request->created_at)->format('d-m-Y H:i') }}</td>
                        <td>
                            <img src="{{ asset('images/' . $request->photo) }}" alt="{{ $request->first_name }} {{ $request->last_name }}" width="60" height="60" class="rounded-circle">
                        </td>
                        <td>{{ $request->first_name }} {{ $request->last_name }}</td>
                        <td>{{ $request->phone }}</td>
                        <td>{{ $request->email }}</td>
                        <td>{{ $request->strategy }}</td>
                        <td>{{ $request->competition->competition_name }}</td>
                        <td>{{ ucfirst($request->competition->account_type) }}</td>
                        <td>{{ $request->competition->trading_group }}</td>
                        <td>
                            <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#approveModal{{ $request->id }}">
                                موافقة
                            </button>
                            <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#rejectModal{{ $request->id }}">رفض</button>

                            <!-- نموذج الموافقة -->
                            <div class="modal fade" id="approveModal{{ $request->id }}" tabindex="-1" aria-labelledby="approveModalLabel{{ $request->id }}" aria-hidden="true">
                                <div class="modal-dialog">
                                    <form action="{{ route('admin.pending_requests.approve', $request->id) }}" method="POST">
                                        @csrf
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="approveModalLabel{{ $request->id }}">موافقة على الطلب</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                                            </div>
                                            <div class="modal-body">
                                                <p>تفاصيل الحساب:</p>
                                                <p><strong>الاسم الأول:</strong> {{ $request->first_name }}</p>
                                                <p><strong>الاسم الأخير:</strong> {{ $request->last_name }}</p>
                                                <p><strong>رقم الهاتف:</strong> {{ $request->phone }}</p>
                                                <p><strong>البريد الإلكتروني:</strong> {{ $request->email }}</p>
                                                <p><strong>المسابقة:</strong> {{ $request->competition->competition_name }}</p>
                                                <p><strong>الرصيد البدئي:</strong> {{ $request->competition->balance }} $</p>
                                                <p><strong>كروب التداول:</strong> {{ $request->competition->trading_group }}</p>
                                                <input type="hidden" name="balance" value="{{ $request->competition->balance }}">
                                                <input type="hidden" name="group" value="{{ $request->competition->trading_group }}">
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                <button type="submit" class="btn btn-primary">موافقة</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                            <!-- نموذج الرفض -->
                            <div class="modal fade" id="rejectModal{{ $request->id }}" tabindex="-1" aria-labelledby="rejectModalLabel{{ $request->id }}" aria-hidden="true">
                                <div class="modal-dialog">
                                    <form action="{{ route('admin.pending_requests.reject', $request->id) }}" method="POST">
                                        @csrf
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="rejectModalLabel{{ $request->id }}">رفض الطلب</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="إغلاق"></button>
                                            </div>
                                            <div class="modal-body">
                                                <div class="mb-3">
                                                    <label for="rejection_reason{{ $request->id }}" class="form-label">سبب الرفض</label>
                                                    <input type="text" class="form-control" id="rejection_reason{{ $request->id }}" name="rejection_reason" required>
                                                </div>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="checkbox" value="1" id="send_reason{{ $request->id }}" name="send_reason">
                                                    <label class="form-check-label" for="send_reason{{ $request->id }}">
                                                        إرسال سبب الرفض إلى العميل
                                                    </label>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                <button type="submit" class="btn btn-danger">رفض</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>

                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    @endif
</div>
@endsection

@push('scripts')
<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.25/css/dataTables.bootstrap5.min.css">

<!-- DataTables JS -->
<script src="https://cdn.datatables.net/1.10.25/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.10.25/js/dataTables.bootstrap5.min.js"></script>
<!-- jQuery -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Bootstrap JS (for modals) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<script>
    $(document).ready(function() {
        $('#pendingRequestsTable').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            },
            "searching": true,
            "ordering": true,
            "paging": true
        });
    });
</script>
@endpush
