@extends('layouts.home')
@vite(['resources/css/app.css', 'resources/js/app.js','resources/js/home.js'])

@section('title', 'الصفحة الرئيسية')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.25/css/dataTables.bootstrap5.min.css">

@section('content')
<div class="container mt-5">
    <script>
        window.competitions = @json($competitions);
    </script>

    <div class="text-center mb-5">
        <a href="{{ route('signup.create') }}" class="btn btn-primary btn-lg">التقديم على المسابقة</a>
    </div>

    <div class="row">
        <!-- جدول المسابقات والمتسابقين -->
        <div class="col-md-8">
            @forelse($competitions as $competition)
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
                        <div>
                            <h4>{{ $competition->competition_name }}</h4>
                        </div>
                        <div>
                            <span class="badge bg-info text-dark mb-2">
                                @if(is_numeric($competition->gift))
                                    الجائزة مبلغ: ${{ number_format($competition->gift, 2) }}
                                @else
                                    الجائزة: {{ $competition->gift }}
                                @endif
                            </span>
                            <span class="badge bg-{{ $competition->is_available ? 'success' : 'secondary' }} me-2">
                                {{ $competition->is_available ? 'متاحة' : 'غير متاحة' }}
                            </span>

                            @if(now()->greaterThan($competition->submission_end_date))
                                <span class="badge bg-danger me-2">
                                    انتهى التقديم
                                </span>
                            @else
                                <span class="badge bg-warning text-dark me-2">
                                    مفتوح التقديم
                                </span>
                            @endif

                            @if(now()->greaterThan($competition->competition_end_date))
                                <span class="badge bg-dark">
                                    انتهت المسابقة
                                </span>
                            @else
                                <span class="badge bg-primary">
                                    المسابقة جارية
                                </span>
                            @endif
                        </div>
                    </div>

                    <div class="card-body">
                        @if($competition->competitors_paginated->isEmpty())
                            <p>لا توجد متسابقين مقبول عليهم حاليًا في هذه المسابقة.</p>
                        @else
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered" id="competitorsTable{{ $competition->id }}">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>الصورة</th>
                                            <th>الاسم الكامل</th>
                                            <th>عائد الحساب (%)</th>
                                            <th>الرصيد الحالي</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @php
                                            $sorted_competitors = $competition->competitors_paginated->sortByDesc(function($competitor) use ($competition) {
                                                return ($competitor->account_balance / $competition->balance - 1) * 100;
                                            });
                                        @endphp
                                        @foreach($sorted_competitors as $index => $competitor)
                                            <tr data-competitor-id="{{ $competitor->id }}">
                                                <td>{{ $index + 1 }}</td>
                                                <td>
                                                    @if($index === 0)
                                                        <i class="fas fa-trophy" title="المركز الأول" style="color: gold; margin-right: 20px;"></i>
                                                    @endif
                                                    <img src="{{ asset('images/' . $competitor->photo) }}" class="competitor-photo" alt="{{ $competitor->first_name }} {{ $competitor->last_name }}" loading="lazy" style="
                                                        width: 60px;
                                                        height: 60px;
                                                        object-fit: cover;
                                                        border-radius: 50%;
                                                    ">
                                                </td>
                                                <td>{{ $competitor->first_name }} {{ $competitor->last_name }}</td>
                                                <td class="account-return">{{ number_format(($competitor->account_balance / $competition->balance - 1) * 100, 2) }}%</td>
                                                <td class="account-balance">${{ number_format($competitor->account_balance, 2) }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>

                                <div class="d-flex justify-content-center">
                                    {{ $competition->competitors_paginated->links() }}
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            @empty
                <div class="alert alert-info">
                    لا توجد مسابقات متاحة حاليًا.
                </div>
            @endforelse
        </div>

        <!-- قسم آخر 3 فائزين -->
        <div class="col-md-4">
            @if($latestWinners->isNotEmpty())
                <div class="card">
                    <div class="card-header text-center">
                        <h4>آخر 3 فائزين</h4>
                    </div>
                    <div class="card-body">
                        @foreach($latestWinners as $winner)
                            <div class="d-flex align-items-center mb-4">
                                <div class="position-relative me-3">
                                    <img src="{{ asset('images/' . $winner->photo) }}" alt="{{ $winner->first_name }} {{ $winner->last_name }}" class="rounded-circle" style="width: 60px; height: 60px; object-fit: cover;">
                                    <i class="fas fa-trophy position-absolute bottom-0 end-0 text-warning" style="font-size: 16px;"></i>
       |                         </div>
                                <div>
                                    <h5 class="mb-1">{{ $winner->first_name }} {{ $winner->last_name }}</h5>
                                    <p class="mb-0"> مسابقة: {{ $winner->competition->competition_name }}</p>
                                    <p class="mb-0">الرصيد المحقق: ${{ number_format($winner->account_balance, 2) }}</p>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
@endsection
