<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>@yield('title') - لوحة الإدارة</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <!-- AdminLTE CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/css/adminlte.min.css">
    <!-- DataTables CSS -->
    @stack('styles')
    <style>
        body {
            font-family: 'Cairo', Tahoma, Geneva, Verdana, sans-serif;
        }
        /* تحسين تصميم السايد بار */
        .sidebar-dark-primary {
            background-color: #343a40;
        }
        .brand-link {
            background-color: #23272b;
            border-bottom: 1px solid #4b545c;
        }
        .navbar-light {
            background-color: #f8f9fa;
        }
        /* تخصيص الأيقونات */
        .nav-icon {
            margin-left: 8px;
        }
        /* تخصيص رابط تغيير كلمة المرور */
        .navbar-nav .nav-link {
            color: #000;
        }
        .navbar-nav .nav-link:hover {
            color: #007bff;
        }
        /* تخصيص العلامة النشطة في السايد بار */
        .nav-sidebar .nav-link.active {
            background-color: #007bff;
            color: #fff;
        }
    </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
    <!-- Wrapper -->
    <div class="wrapper">
        <!-- Navbar -->
        <nav class="main-header navbar navbar-expand navbar-light">


            <!-- روابط النافبار -->
            <ul class="navbar-nav ms-auto">
                <!-- رابط تغيير كلمة المرور -->
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.change-password.form') }}">
                        <i class="fas fa-key"></i>
                        <span>تغيير كلمة المرور</span>
                    </a>
                </li>
                <!-- رابط تسجيل الخروج -->
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('logout') }}"
                       onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                        <i class="fas fa-sign-out-alt"></i>
                        <span>تسجيل الخروج</span>
                    </a>
                    <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                        @csrf
                    </form>
                </li>
            </ul>
            <!-- الزر الذي يطوي السايد بار -->
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
                </li>
            </ul>
        </nav>
        <!-- /.navbar -->

        <!-- السايد بار -->
        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <!-- لوجو الموقع -->
            <a href="{{ route('admin.dashboard') }}" class="brand-link text-center">
                <!-- استبدال النص بالشعار -->
                <img src="{{ asset('/images/LOGO.png') }}" alt="شعار الموقع" style=" width: 150px; height: 50px;">
            </a>

            <!-- محتوى السايد بار -->
            <div class="sidebar">
                <!-- قائمة السايد بار -->
                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu">
                        <!-- عنصر القائمة: الإحصائيات -->
                        <li class="nav-item">
                            <a href="{{ route('admin.dashboard') }}" class="nav-link {{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-tachometer-alt"></i>
                                <p>الإحصائيات</p>
                            </a>
                        </li>
                        <!-- عنصر القائمة: إدارة المسابقات -->
                        <li class="nav-item">
                            <a href="{{ route('competitions.index') }}" class="nav-link {{ request()->routeIs('competitions.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-list"></i>
                                <p>إدارة المسابقات</p>
                            </a>
                        </li>
                        <!-- عنصر القائمة: الطلبات المعلقة -->
                        <li class="nav-item">
                            <a href="{{ route('admin.pending_requests.index') }}" class="nav-link {{ request()->routeIs('admin.pending_requests.*') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-hourglass-start"></i>
                                <p>الطلبات المعلقة</p>
                            </a>
                        </li>
                        <!-- عنصر القائمة: المتسابقون الحاليون -->
                        <li class="nav-item">
                            <a href="{{ route('admin.participants.current') }}" class="nav-link {{ request()->routeIs('admin.participants.current') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-users"></i>
                                <p>المتسابقون الحاليون</p>
                            </a>
                        </li>
                        <!-- عنصر القائمة: المتسابقون المكتملون -->
                        <li class="nav-item">
                            <a href="{{ route('admin.participants.completed') }}" class="nav-link {{ request()->routeIs('admin.participants.completed') ? 'active' : '' }}">
                                <i class="nav-icon fas fa-check-circle"></i>
                                <p>المتسابقون المكتملون</p>
                            </a>
                        </li>
                    </ul>
                </nav>
                <!-- /.sidebar-menu -->
            </div>
            <!-- /.sidebar -->
        </aside>

        <!-- محتوى الصفحة -->
        <div class="content-wrapper">
            <!-- ترويسة المحتوى -->
            <div class="content-header">
                <div class="container-fluid">
                    <h1 class="m-0 text-dark">@yield('title')</h1>
                </div><!-- /.container-fluid -->
            </div>
            <!-- /.content-header -->

            <!-- محتوى الصفحة الفعلي -->
            <section class="content">
                <div class="container-fluid">
                    @yield('content')
                </div><!-- /.container-fluid -->
            </section>
            <!-- /.content -->
        </div>
        <!-- /.content-wrapper -->

        <!-- الفوتر -->
        <footer class="main-footer text-center">
            <strong>isofti.co &copy; {{ date('Y') }}.</strong>
            جميع الحقوق محفوظة.
        </footer>

    </div>
    <!-- ./wrapper -->

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- AdminLTE JS -->
    <script src="https://cdn.jsdelivr.net/npm/admin-lte@3.2/dist/js/adminlte.min.js"></script>
    <!-- DataTables JS -->
    @stack('scripts')
    <!-- سكريبتات إضافية -->
    <script>
        $(function () {
            // تفعيل الشجرة في السايد بار إذا كانت هناك عناصر متعددة
            $('.nav-sidebar').Treeview('init');
        });
    </script>
</body>
</html>
