@extends('layouts.home')

@section('title', 'التقديم على المسابقة')
@vite(['resources/css/app.css', 'resources/js/competition.js']) <!-- تأكد من تضمين ملف CSS وجافا سكريبت -->

@section('content')
<div class="container mt-5">
    <h2 class="text-center mb-4">التقديم على المسابقة</h2>

    <div class="alert alert-info text-center" role="alert">
        <p class="mb-1">يجب أن يكون لديك حساب موثق في الشركة بالمعلومات المقدمة، إذا لم يكن لديك حساب.</p>
        <a href="https://my.ri-fx.com/live_signup" class="btn btn-primary btn-sm mb-2" style="margin-left: 10px;">
            افتح حساب الآن
        </a>
    </div>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <form action="{{ route('signup.store') }}" method="POST" enctype="multipart/form-data" class="p-3" style="background-color: #f9f9f9; border-radius: 8px;">
        @csrf

        <div class="mb-3">
            <label for="first_name" class="form-label">الاسم الأول</label>
            <input type="text" class="form-control" id="first_name" name="first_name" required>
        </div>

        <div class="mb-3">
            <label for="last_name" class="form-label">اسم العائلة</label>
            <input type="text" class="form-control" id="last_name" name="last_name" required>
        </div>

        <div class="mb-3">
            <label for="email" class="form-label">البريد الإلكتروني</label>
            <input type="email" class="form-control" id="email" name="email" required>
        </div>

        <div class="mb-3">
            <label for="phone" class="form-label">رقم الهاتف</label>
            <input type="text" class="form-control" id="phone" name="phone" required>
        </div>

        <div class="mb-3">
            <label for="strategy" class="form-label">الاستراتيجية التي سوف تتبعها</label>
            <textarea class="form-control" id="strategy" name="strategy" rows="3" required></textarea>
        </div>

        <div class="mb-3">
            <label for="competition_id" class="form-label">اختر المسابقة</label>
            <select class="form-select" id="competition_id" name="competition_id" required>
                <option value="" disabled selected>اختر المسابقة المتاحة</option>
                @foreach($competitions as $competition)
                    <option value="{{ $competition->id }}"
                        data-gift="{{ is_numeric($competition->gift) ? '$' . number_format($competition->gift, 2) : $competition->gift }}"
                        data-competition-end="{{ \Carbon\Carbon::parse($competition->competition_end_date)->format('d-m-Y') }}"
                        data-balance="{{ number_format($competition->balance, 2) }}"
                        data-type="{{ $competition->competition_type }}"
                        data-stop-amount="{{ $competition->stop_amount ? '$' . number_format($competition->stop_amount, 2) : '' }}">
                        {{ $competition->competition_name }}
                    </option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label for="photo" class="form-label">صورة المتسابق</label>
            <input type="file" class="form-control" id="photo" name="photo" accept="image/*" required>
        </div>

        <div id="competition-info" class="mb-4" style="display: none;">
            <div class="card border-primary">
                <div class="card-body">
                    <h5 class="card-title text-primary text-center" id="selected-competition-name"></h5>
                    <p class="card-text"><strong>الجائزة:</strong> <span id="selected-competition-gift" class="text-success"></span></p>
                    <p class="card-text d-none" id="stop-amount-container"><strong>أقصى خسارة:</strong> <span id="selected-stop-amount" class="text-danger"></span></p>
                    <p class="card-text"><strong>رصيد الحساب:</strong> <span id="selected-account-balance" class="text-primary"></span></p>
                    <p class="card-text"><strong>تاريخ انتهاء المسابقة:</strong> <span id="selected-competition-end" class="text-danger"></span></p>
                </div>
            </div>
        </div>


        <button type="submit" class="btn btn-primary w-100 mt-3">تقديم</button>
    </form>
</div>
@endsection
