@extends('layouts.home')

@section('title', 'الصفحة الرئيسية')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

@section('content')
<div class="container mt-5">

    <!-- زر الانتقال إلى صفحة التقديم -->
    <div class="text-center mb-5">
        <a href="{{ route('signup.create') }}" class="btn btn-primary btn-lg">التقديم على المسابقة</a>
    </div>

    <!-- قائمة المسابقات والمتسابقين -->
    @forelse($competitions as $competition)
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4>{{ $competition->competition_name }}</h4>
                <span class="badge bg-{{ $competition->is_available ? 'success' : 'secondary' }}">
                    {{ $competition->is_available ? 'متاحة' : 'غير متاحة' }}
                </span>
            </div>
            <div class="card-body">
                @if($competition->competitors->isEmpty())
                    <p>لا توجد متسابقين حاليًا في هذه المسابقة.</p>
                @else
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered" id="competitorsTable{{ $competition->id }}">
                            <thead>
                                <tr>
                                    <th>الصورة</th>
                                    <th>الاسم الكامل</th>
                                    <th>رصيد الحساب</th>
                                    <th>الرصيد الحالي</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($competition->competitors as $index => $competitor)
                                    <tr>
                                        <td>
                                            <i class="fas fa-trophy trophy-icon" title="المركز الأول" style="
                                                font-size: 32px;
                                                margin-left: 5px;
                                                vertical-align: middle;
                                                color: gold;

                                            "></i>
                                            <img src="{{ asset('images/' . $competitor->photo) }}" class="competitor-photo" alt="{{ $competitor->first_name }} {{ $competitor->last_name }}" loading="lazy" style="
                                            width: 80px; /* حجم أصغر */
                                            height: 80px; /* حجم أصغر */
                                            object-fit: cover;
                                            border-radius: 50%; /* شكل دائري */
                                            padding: 0; /* إزالة الحواف إذا كانت موجودة */
                                            margin: 0; /* إزالة المسافات حول الصورة */
                                        ">
                                        </td>
                                        <td>
                                            {{ $competitor->first_name }} {{ $competitor->last_name }}
                                            @if($index === 0)
                                               
                                            @endif
                                        </td>
                                        <td>${{ number_format($competitor->account_balance, 2) }}</td>
                                        <td>${{ number_format($competitor->current_balance, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endif
            </div>
        </div>
    @empty
        <div class="alert alert-info">
            لا توجد مسابقات متاحة حاليًا.
        </div>
    @endforelse

</div>
@endsection


@push('scripts')
<!-- SweetAlert2 for better alert messages (optional) -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Initialize DataTables لكل مسابقة
        @foreach($competitions as $competition)
            $('#competitorsTable{{ $competition->id }}').DataTable({
                "language": {
                    "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
                },
                "order": [[2, "desc"]] // ترتيب حسب رصيد الحساب تنازليًا
            });
        @endforeach

        // Function to fetch and update competitors data
        function fetchCompetitors() {
            fetch("{{ route('api.competitions') }}")
                .then(response => response.json())
                .then(data => {
                    // تحديث الصفحة بناءً على البيانات الجديدة
                    location.reload(); // تبسيط العملية بإعادة تحميل الصفحة
                })
                .catch(error => console.error('Error fetching competitors:', error));
        }

        // Fetch competitors every 30 seconds
        setInterval(fetchCompetitors, 30000); // 30000 milliseconds = 30 seconds
    });
</script>
@endpush
