<?php

// routes/web.php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApplicationController;
use App\Http\Controllers\AdminController;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\CompetitorController;
use App\Http\Controllers\SignupController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Admin\CompetitionController;
use App\Http\Controllers\Admin\PendingRequestController;
use App\Http\Controllers\Admin\ParticipantController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Admin\ProfileController;
use App\Http\Controllers\BalanceController;
//////////////


// مسارات تسجيل الدخول والخروج المخصصة
Route::get('admin/login', [LoginController::class, 'showLoginForm'])
    ->name('login')
    ->middleware('restrict.login.ip');

Route::post('admin/login', [LoginController::class, 'login'])
    ->middleware('restrict.login.ip');

Route::post('logout', [LoginController::class, 'logout'])
    ->name('logout')
    ->middleware('auth');


//////////////

// مسارات تسجيل الدخول والخروج
Route::get('admin/login', [LoginController::class, 'showLoginForm'])->name('login')->middleware('restrict.login.ip');
Route::post('admin/login', [LoginController::class, 'login'])->middleware('restrict.login.ip');
Route::post('logout', [LoginController::class, 'logout'])->name('logout')->middleware('auth');


// Route لجلب قائمة المتسابقين
Route::get('/competitors/current-balances', [BalanceController::class, 'getAccountBalances'])->name('competitors.getAccountBalances');

// الصفحة الرئيسية
Route::get('/', [App\Http\Controllers\CompetitorController::class, 'index'])->name('home');
Route::get('/', [HomeController::class, 'index'])->name('home');


// Routes صفحة التقديم
Route::get('/signup', [SignupController::class, 'create'])->name('signup.create');
Route::post('/signup', [SignupController::class, 'store'])->name('signup.store');



// Routes لوحة الإدارة
Route::prefix('admin')->middleware(['auth', 'is_admin'])->group(function () {
    // لوحة التحكم
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard');

    // إدارة المسابقات (تم إنشاؤها سابقًا)
    Route::resource('competitions', CompetitionController::class);

    // صفحة الطلبات المعلقة
    Route::get('/pending-requests', [PendingRequestController::class, 'index'])->name('admin.pending_requests.index');
    Route::post('/pending-requests/{id}/approve', [PendingRequestController::class, 'approve'])->name('admin.pending_requests.approve');
    Route::post('/pending-requests/{id}/reject', [PendingRequestController::class, 'reject'])->name('admin.pending_requests.reject');

    // صفحة المتسابقون الحاليون
    Route::get('/current-participants', [ParticipantController::class, 'current'])->name('admin.participants.current');
    Route::post('/current-participants/{id}/reject', [ParticipantController::class, 'reject'])->name('admin.participants.reject');
    Route::post('/current-participants/{id}/edit', [ParticipantController::class, 'edit'])->name('admin.participants.edit');

    // صفحة المتسابقون المكتملون
    Route::get('/completed-participants', [ParticipantController::class, 'completed'])->name('admin.participants.completed');


    Route::get('/change-password', [ProfileController::class, 'showChangePasswordForm'])->name('admin.change-password.form');
    Route::post('/change-password', [ProfileController::class, 'changePassword'])->name('admin.change-password');
});

