 <!-- استخدم تخطيط الإدمن إذا كان موجودًا -->

<?php $__env->startSection('title', 'تعديل مسابقة'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <h2>تعديل مسابقة</h2>

    <!-- عرض الأخطاء -->
    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <!-- نموذج تعديل المسابقة -->
    <form action="<?php echo e(route('competitions.update', $competition->id)); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>
        <!-- اسم المسابقة -->
        <div class="mb-3">
            <label for="competition_name" class="form-label">اسم المسابقة</label>
            <input type="text" class="form-control" id="competition_name" name="competition_name" value="<?php echo e(old('competition_name', $competition->competition_name)); ?>" required>
        </div>
        <!-- هل المسابقة متاحة -->
        <div class="mb-3">
            <label for="is_available" class="form-label">هل المسابقة متاحة؟</label>
            <select class="form-select" id="is_available" name="is_available" required>
                <option value="1" <?php echo e($competition->is_available ? 'selected' : ''); ?>>نعم</option>
                <option value="0" <?php echo e(!$competition->is_available ? 'selected' : ''); ?>>لا</option>
            </select>
        </div>
        <!-- الرصيد البدائي للعملاء -->
        <div class="mb-3">
            <label for="balance" class="form-label">الرصيد البدائي للعملاء ($)</label>
            <input type="number" step="0.01" class="form-control" id="balance" name="balance" value="<?php echo e(old('balance', $competition->balance)); ?>" required>
        </div>
        <!-- الجائزة -->
        <div class="mb-3">
            <label for="gift" class="form-label">الجائزة</label>
            <input type="text" class="form-control" id="gift" name="gift" value="<?php echo e(old('gift', $competition->gift)); ?>" required>
        </div>
        <!-- تاريخ انتهاء التقديم -->
        <div class="mb-3">
            <label for="submission_end_date" class="form-label">تاريخ انتهاء التقديم</label>
            <input type="datetime-local" class="form-control" id="submission_end_date" name="submission_end_date" value="<?php echo e(\Carbon\Carbon::parse(old('submission_end_date', $competition->submission_end_date))->format('Y-m-d\TH:i')); ?>" required>
        </div>
        <!-- تاريخ انتهاء المسابقة -->
        <div class="mb-3">
            <label for="competition_end_date" class="form-label">تاريخ انتهاء المسابقة</label>
            <input type="datetime-local" class="form-control" id="competition_end_date" name="competition_end_date" value="<?php echo e(\Carbon\Carbon::parse(old('competition_end_date', $competition->competition_end_date))->format('Y-m-d\TH:i')); ?>" required>
        </div>
        <!-- زر الحفظ -->
        <button type="submit" class="btn btn-primary">تحديث</button>
        <a href="<?php echo e(route('competitions.index')); ?>" class="btn btn-secondary">إلغاء</a>
    </form>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\competition-system\resources\views/admin/competitions/edit.blade.php ENDPATH**/ ?>