<?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js','resources/js/home.js']); ?>

<?php $__env->startSection('title', 'الصفحة الرئيسية'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/1.10.25/css/dataTables.bootstrap5.min.css">

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <script>
        window.competitions = <?php echo json_encode($competitions, 15, 512) ?>;
    </script>

    <div class="text-center mb-5">
        <a href="<?php echo e(route('signup.create')); ?>" class="btn btn-primary btn-lg">التقديم على المسابقة</a>
    </div>

    <div class="row">
        <!-- جدول المسابقات والمتسابقين -->
        <div class="col-md-8">
            <?php $__empty_1 = true; $__currentLoopData = $competitions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $competition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="card mb-4">
                    <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
                        <div>
                            <h4><?php echo e($competition->competition_name); ?></h4>
                        </div>
                        <div>
                            <span class="badge bg-info text-dark mb-2">
                                <?php if(is_numeric($competition->gift)): ?>
                                    الجائزة مبلغ: $<?php echo e(number_format($competition->gift, 2)); ?>

                                <?php else: ?>
                                    الجائزة: <?php echo e($competition->gift); ?>

                                <?php endif; ?>
                            </span>
                            <span class="badge bg-<?php echo e($competition->is_available ? 'success' : 'secondary'); ?> me-2">
                                <?php echo e($competition->is_available ? 'متاحة' : 'غير متاحة'); ?>

                            </span>

                            <?php if(now()->greaterThan($competition->submission_end_date)): ?>
                                <span class="badge bg-danger me-2">
                                    انتهى التقديم
                                </span>
                            <?php else: ?>
                                <span class="badge bg-warning text-dark me-2">
                                    مفتوح التقديم
                                </span>
                            <?php endif; ?>

                            <?php if(now()->greaterThan($competition->competition_end_date)): ?>
                                <span class="badge bg-dark">
                                    انتهت المسابقة
                                </span>
                            <?php else: ?>
                                <span class="badge bg-primary">
                                    المسابقة جارية
                                </span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="card-body">
                        <?php if($competition->competitors_paginated->isEmpty()): ?>
                            <p>لا توجد متسابقين مقبول عليهم حاليًا في هذه المسابقة.</p>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-striped table-bordered" id="competitorsTable<?php echo e($competition->id); ?>">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>الصورة</th>
                                            <th>الاسم الكامل</th>
                                            <th>عائد الحساب (%)</th>
                                            <th>الرصيد الحالي</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $sorted_competitors = $competition->competitors_paginated->sortByDesc(function($competitor) use ($competition) {
                                                return ($competitor->account_balance / $competition->balance - 1) * 100;
                                            });
                                        ?>
                                        <?php $__currentLoopData = $sorted_competitors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $competitor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr data-competitor-id="<?php echo e($competitor->id); ?>">
                                                <td><?php echo e($index + 1); ?></td>
                                                <td>
                                                    <?php if($index === 0): ?>
                                                        <i class="fas fa-trophy" title="المركز الأول" style="color: gold; margin-right: 20px;"></i>
                                                    <?php endif; ?>
                                                    <img src="<?php echo e(asset('images/' . $competitor->photo)); ?>" class="competitor-photo" alt="<?php echo e($competitor->first_name); ?> <?php echo e($competitor->last_name); ?>" loading="lazy" style="
                                                        width: 60px;
                                                        height: 60px;
                                                        object-fit: cover;
                                                        border-radius: 50%;
                                                    ">
                                                </td>
                                                <td><?php echo e($competitor->first_name); ?> <?php echo e($competitor->last_name); ?></td>
                                                <td class="account-return"><?php echo e(number_format(($competitor->account_balance / $competition->balance - 1) * 100, 2)); ?>%</td>
                                                <td class="account-balance">$<?php echo e(number_format($competitor->account_balance, 2)); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>

                                <div class="d-flex justify-content-center">
                                    <?php echo e($competition->competitors_paginated->links()); ?>

                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="alert alert-info">
                    لا توجد مسابقات متاحة حاليًا.
                </div>
            <?php endif; ?>
        </div>

        <!-- قسم آخر 3 فائزين -->
        <div class="col-md-4">
            <?php if($latestWinners->isNotEmpty()): ?>
                <div class="card">
                    <div class="card-header text-center">
                        <h4>آخر 3 فائزين</h4>
                    </div>
                    <div class="card-body">
                        <?php $__currentLoopData = $latestWinners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $winner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="d-flex align-items-center mb-4">
                                <div class="position-relative me-3">
                                    <img src="<?php echo e(asset('images/' . $winner->photo)); ?>" alt="<?php echo e($winner->first_name); ?> <?php echo e($winner->last_name); ?>" class="rounded-circle" style="width: 60px; height: 60px; object-fit: cover;">
                                    <i class="fas fa-trophy position-absolute bottom-0 end-0 text-warning" style="font-size: 16px;"></i>
       |                         </div>
                                <div>
                                    <h5 class="mb-1"><?php echo e($winner->first_name); ?> <?php echo e($winner->last_name); ?></h5>
                                    <p class="mb-0"> مسابقة: <?php echo e($winner->competition->competition_name); ?></p>
                                    <p class="mb-0">الرصيد المحقق: $<?php echo e(number_format($winner->account_balance, 2)); ?></p>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.home', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\LaravelProjects\competition-system\resources\views/home.blade.php ENDPATH**/ ?>