<?php $__env->startSection('title', 'المتسابقون الحاليون'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/css/currentParticipants.css', 'resources/js/currentParticipants.js']); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <h2>المتسابقون الحاليون</h2>

    <?php if(session('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="mb-4">
        <label for="filterCompetition" class="form-label">اختر المسابقة</label>
        <select class="form-select" id="filterCompetition">
            <option value="">كل المسابقات</option>
            <?php $__currentLoopData = $competitions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $competition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($competition->id); ?>"><?php echo e($competition->competition_name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <table class="table table-striped table-bordered" id="currentParticipantsTable">
        <thead>
            <tr>
                <th>#</th>
                <th>تاريخ الدخول</th>
                <th>الصورة</th>
                <th>الاسم</th>
                <th>رقم الهاتف</th>
                <th>البريد الإلكتروني</th>
                <th>الاستراتيجية</th>
                <th>رصيد الحساب</th>
                <th>رقم الحساب</th>
                <th>الإجراءات</th>
                <th style="display: none;">Competition ID</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $participants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $participant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($participant->updated_at)->format('d-m-Y H:i')); ?></td>
                    <td><img src="<?php echo e(asset('images/' . $participant->photo)); ?>" alt="<?php echo e($participant->first_name); ?> <?php echo e($participant->last_name); ?>" class="rounded-circle"></td>
                    <td><?php echo e($participant->first_name); ?> <?php echo e($participant->last_name); ?></td>
                    <td><?php echo e($participant->phone); ?></td>
                    <td><?php echo e($participant->email); ?></td>
                    <td><?php echo e($participant->strategy); ?></td>
                    <td>$<?php echo e(number_format($participant->account_balance, 2)); ?></td>
                    <td><?php echo e($participant->account_number); ?></td>
                    <td>
                        <button class="btn btn-danger btn-sm" data-bs-toggle="modal" data-bs-target="#rejectModal<?php echo e($participant->id); ?>">رفض</button>
                        <button class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#editModal<?php echo e($participant->id); ?>">تعديل</button>
                    </td>
                    <td style="display: none;"><?php echo e($participant->competition_id); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\competition-system\resources\views/admin/participants/current.blade.php ENDPATH**/ ?>